#include <stdio.h>

#define VERSION "V2.21"

#define MAXVERSIONS 9

struct offsets
{
        char    *name;
        long    checksize;
        long    flamepatch;
        long    burst1;
        long    burst2;
        long    burst3;
};

struct offsets offsets[] = {
       "V1.07",
       2961920,
       0x224812,
       0x225030,
       0x226ae8,
       0x228638,

       "V1.06 Wildfire",
       2961965,
       0x2247F6,
       0x225018,
       0x226ad0,
       0x228620,

       "V1.06",
       2827776,
       0x2247F6,
       0x225018,
       0x226ad0,
       0x228620,

       "V1.05",
       2826240,
       0x22294e,
       0x222eb0,
       0x224968,
       0x2264b8,

       "V1.05r",
       2818048,
       0x22294e,
       0x222eb0,
       0x224968,
       0x2264b8,

       "V1.02 Dutch",
       2703360,
       0x20836e,
       0x2088f0,
       0x20a3a8,
       0x20bef8,

       "V1.02 German",
       2919936,
       0x21A4F6,
       0x21AA58,
       0x21C510,
       0x21E060,

       "V1.02b German",
       2924544,
       0x21b276,
       0x21ba98,
       0x21d550,
       0x21f0a0,

       "V1.05 German",
       2719775,
       0x20A3C6,
       0x20AC00,
       0x20C6B8,
       0x20E208,

};

main(int argc,char *argv[])
{
        unsigned char	*buffer;
	long	buffsize;
	FILE	*exefile;
	unsigned long	c;
        long     ver;

	printf("\nJagged Alliance 2 Patch %s\n\n",VERSION);

        if(argc < 2){
help:
		printf("\nUsage: ja2patch <executable>\n\n",argv[0]);
		return(0);
	}

	if(!(exefile = fopen(argv[1],"rb"))){
		printf("Can't open %s!\n",argv[1]);
		goto help;
	}
	fseek(exefile,0,SEEK_END);
	buffsize = ftell(exefile);
	fseek(exefile,0,SEEK_SET);
	for(ver = 0 ; ver < MAXVERSIONS ; ver++){
                if(offsets[ver].checksize == buffsize){
                       printf("%s version of executable detected\n",offsets[ver].name);
                       break;
                }
        }
        if(ver >= MAXVERSIONS){
        	printf("Incorrect version of executable\n");
		fclose(exefile);
		return(1);
	}
	buffer = (char *) malloc(buffsize);
	if(!buffer){
		printf("Unable to allocate %d bytes.\n",buffsize);
		fclose(exefile);
		return(1);
	}

        printf("\nReading binary data...");

	c = fread(buffer,1,buffsize,exefile);
	if (c != buffsize){
		printf("Error while reading executable (Read %d of %d bytes).\n",c,buffsize);
		fclose(exefile);
		return(1);
	}
	fclose(exefile);

        printf("\nPatching...");

        /* Flamethrower */

        strcpy((buffer + offsets[ver].flamepatch),"MINIBOOM.STI");

        /* Burst Bug */

        *(buffer + offsets[ver].burst1) = 0x00;
        *(buffer + offsets[ver].burst2) = 0x00;
        *(buffer + offsets[ver].burst3) = 0x00;

        if(!(exefile = fopen(argv[1],"wb"))){
		printf("Error writing %s!\n",argv[1]);
		fclose(exefile);
		return(1);
	}
        printf("\nSaving binary data...");
        fwrite(buffer,1,buffsize,exefile);
	if(ferror(exefile)){
		printf("Error writing %s!\n",argv[1]);
		fclose(exefile);
		return(1);
	}
        fclose(exefile);
        printf("\nDone!\n");
	return(0);
}

